from dataclasses import asdict, dataclass, is_dataclass
import json


@dataclass
class DriveItem:
    drive_id: str
    item_id: str


@dataclass
class LastModifiedRequest:
    id: str
    driveitem: DriveItem


class DataclassJSONEncoder(json.JSONEncoder):
    def default(self, o):
        if is_dataclass(o):
            return asdict(o)
        return super().default(o)
