
from enumfields.drf.fields import EnumField
from rest_framework import serializers

from wiki.integrations.ms.consts import DOC_CREATION_METHOD_PARAMS_MAP, DocCreationSourceType, Ms365DocType
from wiki.pages.logic.tags import supertag_validator


class ImportSharedDocxRequest(serializers.Serializer):
    supertag = serializers.CharField(required=True)
    shared_link = serializers.URLField(required=True)


class PreviewSharedDocxRequest(serializers.Serializer):
    shared_link = serializers.URLField(required=True)


class SetupServiceAccountRequest(serializers.Serializer):
    force = serializers.BooleanField(default=False)


class CheckAccessRequest(serializers.Serializer):
    iframe_src = serializers.URLField()


class CreatePageRequestOptions(serializers.Serializer):
    url = serializers.CharField(required=False)
    doctype = EnumField(Ms365DocType, required=False)
    mime = serializers.CharField(required=False)

    def validate(self, attrs):
        if all(attrs.get(name) is None for name in ('url', 'doctype', 'mime')):
            raise serializers.ValidationError('Some options parameter is required')

        return attrs


class FinalizeUploadRequest(serializers.Serializer):
    upload_session = serializers.CharField(required=True)


class CreatePageRequest(serializers.Serializer):
    title = serializers.CharField(required=True)
    supertag = serializers.CharField(required=True, validators=[supertag_validator])
    source = EnumField(DocCreationSourceType)
    options = CreatePageRequestOptions()

    def validate(self, attrs):
        options = attrs.get('options')
        if not options or not options.get(DOC_CREATION_METHOD_PARAMS_MAP.get(attrs.get('source'))):
            raise serializers.ValidationError(
                {
                    'options': 'Required options parameter "{}" for source={} is empty'.format(
                        DOC_CREATION_METHOD_PARAMS_MAP.get(attrs.get('source')), attrs.get('source')
                    )
                }
            )

        return attrs


class FinalizeUploadSessionRequest(serializers.Serializer):
    upload_session = serializers.CharField(required=True)
