import uuid

from django.core.cache import caches

from wiki.integrations.ms.exceptions import Ms365BadUploadSession

cache_source = caches['upload_intents']


class UploadIntentStorage(object):
    @classmethod
    def store_intent(cls, intent):
        guid = str(uuid.uuid4())
        cache_source.set(guid, intent)
        return guid

    @classmethod
    def load_intent(cls, guid):
        cache = cache_source.get(guid)
        if not cache:
            raise Ms365BadUploadSession()
        return cache

    @classmethod
    def delete_intent(cls, guid):
        # по какой-то неведомой причине кеш с бекендом в монге не может в удаление!
        # как только переедем на Redis, раскостылим
        cache_source.set(guid, None)
        cache_source.delete(guid)
