# Generated by Django 1.9.7 on 2016-07-19 11:05


import django.db.models.manager
from django.conf import settings
from django.db import migrations, models

from wiki.legacy.orm import JSONField

operations_common = []

staff_fields = [
    ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
    ('native_lang', models.CharField(blank=True, default=b'', max_length=2)),
    ('intranet_status', models.IntegerField(default=1)),
    ('created_at', models.DateTimeField(editable=False)),
    ('modified_at', models.DateTimeField(editable=False)),
    ('from_staff_id', models.PositiveIntegerField(db_index=True, default=0)),
    ('login', models.CharField(db_index=True, default=b'', max_length=50)),
    ('normal_login', models.CharField(db_index=True, default=b'', max_length=50)),
    ('login_mail', models.CharField(db_index=True, default=b'', max_length=50)),
    (
        'domain',
        models.CharField(
            choices=[
                (b'A', b'auto.ru'),
                (b'C', b'comptek.ru'),
                (b'Y', b'yandex-team.ru'),
                (b'U', b'yandex-team.com.ua'),
                (b'M', b'yamoney.ru'),
                (b'P', b'yaprobki.ru'),
                (b'W', b'yandex-team.com'),
                (b'T', b'yandex-team.com.tr'),
            ],
            default=b'',
            max_length=1,
        ),
    ),
    ('login_ld', models.CharField(db_index=True, max_length=50, unique=True)),
    ('guid', models.CharField(default=b'', max_length=47, null=True)),
    ('first_name', models.CharField(db_index=True, default=b'', max_length=50)),
    ('first_name_en', models.CharField(db_index=True, default=b'', max_length=50)),
    ('middle_name', models.CharField(default=b'', max_length=50)),
    ('hide_middle_name', models.BooleanField(default=True)),
    ('last_name', models.CharField(db_index=True, default=b'', max_length=100)),
    ('last_name_en', models.CharField(db_index=True, default=b'', max_length=100)),
    ('en_name', models.CharField(default=b'', max_length=255)),
    ('tz', models.CharField(default=b'', max_length=30)),
    ('is_homeworker', models.BooleanField(default=False)),
    ('is_robot', models.BooleanField(default=False)),
    (
        'affiliation',
        models.CharField(
            choices=[
                (b'yandex', 'intranet_stuff.Staff_AffiliationYandex'),
                (b'yamoney', 'intranet_stuff.Staff_AffiliationYamoney'),
                (b'external', 'intranet_stuff.Staff_AffiliationExternal'),
            ],
            db_index=True,
            max_length=32,
        ),
    ),
    ('has_exchange', models.BooleanField(default=False)),
    ('user', models.OneToOneField(null=True, on_delete=models.CASCADE, to=settings.AUTH_USER_MODEL)),
    ('uid', models.CharField(db_index=True, max_length=16, null=True, unique=True)),
    ('is_dismissed', models.BooleanField(default=False)),
    ('work_email', models.CharField(db_index=True, default=b'', max_length=100)),
    ('wiki_name', models.CharField(db_index=True, default=b'', max_length=100)),
    (
        'lang_ui',
        models.CharField(
            choices=[(b'en', b'English'), (b'ru', b'Russian'), (b'tr', b'Turkish')], default=b'', max_length=2
        ),
    ),
    ('lang_content', models.CharField(default=b'', max_length=255)),
    ('service_profile', JSONField(default=b'{}', max_length=4000)),
    (
        'gender',
        models.CharField(
            choices=[(b'M', 'intranet_stuff.Staff_Male'), (b'F', 'intranet_stuff.Staff_Female')],
            default=b'',
            max_length=1,
        ),
    ),
    ('last_offer_id', models.IntegerField(null=True)),
]

staff_int_only = [
    ('birthday', models.DateField(null=True)),
    ('hide_birthday_year', models.BooleanField(default=False)),
    (
        'family_status',
        models.CharField(
            choices=[(b'S', 'intranet_stuff.Staff_SingleMale'), (b'M', 'intranet_stuff.Staff_MarriedMale')],
            default=b'',
            max_length=1,
        ),
    ),
    ('children', models.PositiveSmallIntegerField(null=True)),
    ('car', models.CharField(default=b'', max_length=100)),
    ('car_num', models.CharField(default=b'', max_length=100)),
    ('address', models.CharField(default=b'', max_length=255)),
    ('address_en', models.CharField(default=b'', max_length=255)),
    (
        'edu_status',
        models.CharField(
            choices=[
                (b'S', 'intranet_stuff.Staff_SecondaryEducation'),
                (b'I', 'intranet_stuff.Staff_HigherIncompleteEducation'),
                (b'B', 'intranet_stuff.Staff_BachelorsDegreeEducation'),
                (b'M', 'intranet_stuff.Staff_MastersDegreeEducation'),
                (b'P', 'intranet_stuff.Staff_SpecialistDegreeEducation'),
                (b'D', 'intranet_stuff.Staff_AcademicDegreeEducation'),
            ],
            default=b'',
            max_length=1,
        ),
    ),
    (
        'edu_direction',
        models.CharField(
            choices=[
                (b'T', 'intranet_stuff.Staff_TechnicalDirection'),
                (b'L', 'intranet_stuff.Staff_LiberalDirection'),
                (b'N', 'intranet_stuff.Staff_NaturalDirection'),
                (b'E', 'intranet_stuff.Staff_EconomicDirection'),
                (b'B', 'intranet_stuff.Staff_BusinessDirection'),
            ],
            default=b'',
            max_length=1,
        ),
    ),
    ('edu_place', models.CharField(default=b'', max_length=255)),
    ('edu_place_en', models.CharField(default=b'', max_length=255)),
    ('edu_date', models.DateField(null=True)),
    ('is_big_boss', models.BooleanField(default=False)),
    ('department', models.ForeignKey(null=True, to='intranet.Department', on_delete=models.CASCADE)),
    ('office', models.ForeignKey(null=True, to='intranet.Office', on_delete=models.CASCADE)),
    ('desk_id', models.IntegerField(null=True)),
    ('join_at', models.DateField(null=True)),
    ('quit_at', models.DateField(null=True)),
    ('position', models.CharField(default=b'', max_length=150)),
    ('position_en', models.CharField(default=b'', max_length=150)),
    (
        'employment',
        models.CharField(
            choices=[
                (b'F', 'intranet_stuff.Staff_FullEmployment'),
                (b'P', 'intranet_stuff.Staff_PartTimeEmployment'),
                (b'D', 'intranet_stuff.Staff_SecondaryJob'),
            ],
            default=b'',
            max_length=1,
        ),
    ),
    ('work_phone', models.PositiveIntegerField(db_index=True, null=True)),
    ('mobile_phone', models.CharField(default=b'', max_length=100)),
]

operations_b2b = [
    migrations.CreateModel(
        name='Staff',
        fields=staff_fields,
        options={
            'abstract': False,
            'db_table': 'intranet_staff',
        },
    )
]

operations_intranet = [
    migrations.CreateModel(
        name='Country',
        fields=[
            ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ('native_lang', models.CharField(blank=True, default=b'', max_length=2)),
            ('intranet_status', models.IntegerField(default=1)),
            ('created_at', models.DateTimeField(editable=False)),
            ('modified_at', models.DateTimeField(editable=False)),
            ('color', models.CharField(default=b'000000', max_length=6)),
            ('position', models.IntegerField(default=0)),
            ('name', models.CharField(max_length=100)),
            ('name_en', models.CharField(max_length=100)),
            ('yandex_domain', models.CharField(max_length=100)),
            ('code', models.CharField(blank=True, default=b'', max_length=2)),
            ('geo_base_id', models.IntegerField()),
        ],
        options={
            'abstract': False,
            'db_table': 'intranet_country',
        },
    ),
    migrations.CreateModel(
        name='City',
        fields=[
            ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ('native_lang', models.CharField(blank=True, default=b'', max_length=2)),
            ('intranet_status', models.IntegerField(default=1)),
            ('created_at', models.DateTimeField(editable=False)),
            ('modified_at', models.DateTimeField(editable=False)),
            ('color', models.CharField(default=b'000000', max_length=6)),
            ('position', models.IntegerField(default=0)),
            ('name', models.CharField(max_length=100)),
            ('name_en', models.CharField(blank=True, default=b'', max_length=100)),
            ('geo_id', models.IntegerField(default=0)),
            (
                'country',
                models.ForeignKey(
                    blank=True, null=True, to='intranet.Country', on_delete=models.CASCADE
                ),
            ),
        ],
        options={
            'abstract': False,
            'db_table': 'intranet_city',
        },
    ),
    migrations.CreateModel(
        name='Office',
        fields=[
            ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ('native_lang', models.CharField(blank=True, default=b'', max_length=2)),
            ('intranet_status', models.IntegerField(default=1)),
            ('created_at', models.DateTimeField(editable=False)),
            ('modified_at', models.DateTimeField(editable=False)),
            ('position', models.IntegerField(default=0)),
            ('from_staff_id', models.PositiveIntegerField(db_index=True)),
            ('name', models.CharField(max_length=255)),
            ('name_en', models.CharField(default=b'', max_length=255)),
            ('color', models.CharField(max_length=10)),
            ('have_map', models.BooleanField(default=False)),
            ('coord_x', models.FloatField(null=True)),
            ('coord_y', models.FloatField(null=True)),
            ('zoom', models.PositiveSmallIntegerField(default=0)),
            ('address1', models.CharField(default=b'', max_length=255)),
            ('address2', models.CharField(default=b'', max_length=255)),
            ('address1_en', models.CharField(default=b'', max_length=255)),
            ('address2_en', models.CharField(default=b'', max_length=255)),
            ('phone', models.CharField(default=b'', max_length=50)),
            ('fax', models.CharField(default=b'', max_length=50)),
            ('code', models.CharField(default=b'', max_length=20)),
            ('tz', models.CharField(default=b'', max_length=20)),
            ('filter_id', models.CharField(blank=True, default=b'', max_length=40)),
            (
                'city',
                models.ForeignKey(
                    blank=True, null=True, to='intranet.City', on_delete=models.CASCADE
                ),
            ),
        ],
        options={
            'abstract': False,
            'db_table': 'intranet_office',
        },
    ),
    migrations.CreateModel(
        name='DepartmentKind',
        fields=[
            ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ('native_lang', models.CharField(blank=True, default=b'', max_length=2)),
            ('intranet_status', models.IntegerField(default=1)),
            ('created_at', models.DateTimeField(editable=False)),
            ('modified_at', models.DateTimeField(editable=False)),
            ('name', models.CharField(max_length=64)),
            ('name_en', models.CharField(blank=True, max_length=64)),
            ('rank', models.IntegerField(default=0)),
            ('slug', models.CharField(max_length=64, null=True, unique=True)),
        ],
        options={
            'abstract': False,
            'db_table': 'intranet_department_kind',
        },
    ),
    migrations.CreateModel(
        name='Department',
        fields=[
            ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ('native_lang', models.CharField(blank=True, default=b'', max_length=2)),
            ('intranet_status', models.IntegerField(default=1)),
            ('created_at', models.DateTimeField(editable=False)),
            ('modified_at', models.DateTimeField(editable=False)),
            ('position', models.IntegerField(default=0)),
            ('from_staff_id', models.PositiveIntegerField(db_index=True)),
            ('name', models.CharField(max_length=255)),
            ('en_name', models.CharField(default=b'', max_length=255)),
            ('name_en', models.CharField(default=b'', max_length=255)),
            ('short_name', models.CharField(default=b'', max_length=255)),
            ('short_name_en', models.CharField(default=b'', max_length=255)),
            ('code', models.CharField(default=b'', max_length=20)),
            ('url', models.CharField(default=b'', max_length=255, unique=True)),
            ('dynamic_url', models.CharField(max_length=255, null=True, unique=True)),
            ('bg_color', models.CharField(default=b'', max_length=20)),
            ('fg_color', models.CharField(default=b'', max_length=20)),
            ('maillists', models.CharField(default=b'', max_length=4096)),
            ('clubs', models.CharField(default=b'', max_length=4096)),
            ('wiki_page', models.CharField(default=b'', max_length=2048)),
            ('jira_project', models.CharField(default=b'', max_length=255)),
            ('description', models.CharField(default=b'', max_length=4096)),
            ('description_en', models.CharField(default=b'', max_length=4096)),
            ('lft', models.PositiveIntegerField(db_index=True, editable=False)),
            ('rght', models.PositiveIntegerField(db_index=True, editable=False)),
            ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
            ('level', models.PositiveIntegerField(db_index=True, editable=False)),
            (
                'kind',
                models.ForeignKey(null=True, to='intranet.DepartmentKind', on_delete=models.CASCADE),
            ),
        ],
        options={
            'abstract': False,
            'db_table': 'intranet_department',
        },
        managers=[
            ('tree', django.db.models.manager.Manager()),
        ],
    ),
    migrations.AddField(
        model_name='department',
        name='parent',
        field=models.ForeignKey(
            blank=True,
            null=True,
            related_name='children',
            to='intranet.Department',
            on_delete=models.CASCADE,
        ),
    ),
    migrations.CreateModel(
        name='Staff',
        fields=staff_fields + staff_int_only,
        options={
            'abstract': False,
            'db_table': 'intranet_staff',
        },
    ),
    migrations.CreateModel(
        name='DepartmentStaff',
        fields=[
            ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            (
                'role',
                models.CharField(
                    choices=[(b'C', 'intranet_stuff.Department_chief'), (b'D', 'intranet_stuff.Department_deputy')],
                    max_length=1,
                ),
            ),
            (
                'department',
                models.ForeignKey(null=True, to='intranet.Department', on_delete=models.CASCADE),
            ),
            ('staff', models.ForeignKey(null=True, to='intranet.Staff', on_delete=models.CASCADE)),
        ],
        options={
            'db_table': 'intranet_departmentstaff',
        },
    ),
    migrations.CreateModel(
        name='DepartmentStaffCounter',
        fields=[
            ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ('day', models.DateField(db_index=True)),
            ('staff_counter', models.PositiveSmallIntegerField()),
            ('department', models.ForeignKey(to='intranet.Department', on_delete=models.CASCADE)),
        ],
        options={
            'db_table': 'intranet_departmentstaffcounter',
        },
    ),
    migrations.AlterUniqueTogether(
        name='departmentstaffcounter',
        unique_together=set([('department', 'day')]),
    ),
    migrations.CreateModel(
        name='Service',
        fields=[
            ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ('native_lang', models.CharField(blank=True, default=b'', max_length=2)),
            ('intranet_status', models.IntegerField(default=1)),
            ('created_at', models.DateTimeField(editable=False)),
            ('modified_at', models.DateTimeField(editable=False)),
            ('from_staff_id', models.PositiveIntegerField(db_index=True, editable=False)),
            (
                'jira_key',
                models.CharField(
                    blank=True, default=b'', max_length=20, verbose_name='intranet_stuff.Service.jira_key'
                ),
            ),
            ('name', models.CharField(max_length=255, verbose_name='intranet_stuff.Service.name')),
            (
                'description',
                models.TextField(blank=True, default=b'', verbose_name='intranet_stuff.Service.description'),
            ),
            (
                'url',
                models.CharField(blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.Service.url'),
            ),
            (
                'url_wiki',
                models.CharField(
                    blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.Service.url_wiki'
                ),
            ),
            (
                'wiki_supertag',
                models.CharField(
                    blank=True,
                    db_index=True,
                    default=b'',
                    max_length=255,
                    verbose_name='intranet_stuff.Service.wiki_supertag',
                ),
            ),
            (
                'url_statface',
                models.CharField(
                    blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.Service.url_statface'
                ),
            ),
            (
                'url_monitoring',
                models.CharField(
                    blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.Service.url_monitoring'
                ),
            ),
            (
                'url_ya_clubs',
                models.CharField(
                    blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.Service.url_ya_clubs'
                ),
            ),
            (
                'url_at_clubs',
                models.CharField(
                    blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.Service.url_at_clubs'
                ),
            ),
            (
                'url_vcs',
                models.CharField(
                    blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.Service.url_vcs'
                ),
            ),
            (
                'url_beta',
                models.CharField(
                    blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.Service.url_beta'
                ),
            ),
            (
                'url1',
                models.CharField(blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.Service.url1'),
            ),
            (
                'url1_title',
                models.CharField(
                    blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.Service.url1_title'
                ),
            ),
            (
                'url2',
                models.CharField(blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.Service.url2'),
            ),
            (
                'url2_title',
                models.CharField(
                    blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.Service.url2_title'
                ),
            ),
            (
                'url3',
                models.CharField(blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.Service.url3'),
            ),
            (
                'url3_title',
                models.CharField(
                    blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.Service.url3_title'
                ),
            ),
            (
                'url4',
                models.CharField(blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.Service.url4'),
            ),
            (
                'url4_title',
                models.CharField(
                    blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.Service.url4_title'
                ),
            ),
            (
                'url_help',
                models.CharField(
                    blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.Service.url_help'
                ),
            ),
            (
                'maillist',
                models.EmailField(
                    blank=True, default=b'', max_length=254, null=True, verbose_name='intranet_stuff.Service.maillist'
                ),
            ),
            (
                'metrika_id',
                models.PositiveIntegerField(blank=True, null=True, verbose_name='intranet_stuff.Service.metrika_id'),
            ),
            ('keywords', models.TextField(blank=True, default=b'', verbose_name='intranet_stuff.Service.keywords')),
            ('position', models.IntegerField(db_index=True, default=0, editable=False)),
            ('lft', models.PositiveIntegerField(db_index=True, editable=False)),
            ('rght', models.PositiveIntegerField(db_index=True, editable=False)),
            ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
            ('level', models.PositiveIntegerField(db_index=True, editable=False)),
            (
                'owner',
                models.ForeignKey(
                    blank=True,
                    null=True,
                    to='intranet.Staff',
                    verbose_name='intranet_stuff.Service.owner',
                    on_delete=models.CASCADE,
                ),
            ),
        ],
        options={
            'abstract': False,
            'db_table': 'intranet_service',
        },
        managers=[
            ('tree', django.db.models.manager.Manager()),
        ],
    ),
    migrations.AddField(
        model_name='service',
        name='parent',
        field=models.ForeignKey(
            blank=True,
            null=True,
            related_name='children',
            to='intranet.Service',
            verbose_name='intranet_stuff.Service.parent',
            on_delete=models.CASCADE,
        ),
    ),
    migrations.CreateModel(
        name='ServiceRole',
        fields=[
            ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ('native_lang', models.CharField(blank=True, default=b'', max_length=2)),
            ('intranet_status', models.IntegerField(default=1)),
            ('created_at', models.DateTimeField(editable=False)),
            ('modified_at', models.DateTimeField(editable=False)),
            ('from_staff_id', models.PositiveIntegerField(db_index=True, editable=False)),
            ('name', models.CharField(default=b'', max_length=255, verbose_name='intranet_stuff.ServiceRole.name')),
            ('position', models.IntegerField(db_index=True, verbose_name='intranet_stuff.ServiceRole.position')),
            ('senior', models.BooleanField(default=False, verbose_name='intranet_stuff.ServiceRole.senior')),
        ],
        options={
            'abstract': False,
            'db_table': 'intranet_servicerole',
        },
    ),
    migrations.CreateModel(
        name='ServiceMember',
        fields=[
            ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ('from_staff_id', models.PositiveIntegerField(db_index=True)),
            (
                'custom_role',
                models.CharField(
                    blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.ServiceMember.custom_role'
                ),
            ),
            (
                'description',
                models.CharField(
                    blank=True, default=b'', max_length=255, verbose_name='intranet_stuff.ServiceMember.description'
                ),
            ),
            ('position', models.IntegerField(db_index=True, default=0, editable=False)),
            ('is_temp', models.BooleanField(default=False, verbose_name='intranet_stuff.ServiceMember.is_temp')),
            (
                'occupancy',
                models.PositiveSmallIntegerField(
                    blank=True,
                    choices=[
                        (8, 'intranet_stuff.ServiceMember_full'),
                        (4, 'intranet_stuff.ServiceMember_partial'),
                        (1, 'intranet_stuff.ServiceMember_slightly'),
                    ],
                    default=0,
                    verbose_name='intranet_stuff.ServiceMember.occupancy',
                ),
            ),
            ('weight', models.FloatField(blank=True, default=0, verbose_name='intranet_stuff.ServiceMember.weight')),
            (
                'role',
                models.ForeignKey(
                    to='intranet.ServiceRole',
                    verbose_name='intranet_stuff.ServiceMember.role',
                    on_delete=models.CASCADE,
                ),
            ),
            (
                'service',
                models.ForeignKey(
                    to='intranet.Service',
                    verbose_name='intranet_stuff.ServiceMember.service',
                    on_delete=models.CASCADE,
                ),
            ),
            (
                'staff',
                models.ForeignKey(
                    to='intranet.Staff',
                    verbose_name='intranet_stuff.ServiceMember.staff',
                    on_delete=models.CASCADE,
                ),
            ),
        ],
        options={
            'db_table': 'intranet_servicemember',
        },
    ),
    migrations.CreateModel(
        name='Group',
        fields=[
            ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ('native_lang', models.CharField(blank=True, default=b'', max_length=2)),
            ('intranet_status', models.IntegerField(default=1)),
            ('created_at', models.DateTimeField(editable=False)),
            ('modified_at', models.DateTimeField(editable=False)),
            ('service_id', models.PositiveIntegerField(blank=True, null=True)),
            ('role_scope_id', models.CharField(blank=True, max_length=127, null=True)),
            ('name', models.CharField(db_index=True, max_length=127)),
            ('url', models.CharField(db_index=True, max_length=255, unique=True)),
            ('code', models.CharField(db_index=True, default=b'', max_length=127)),
            ('description', models.TextField()),
            ('position', models.IntegerField(default=0, null=True)),
            (
                'type',
                models.PositiveSmallIntegerField(
                    choices=[(0, b'wiki'), (1, b'department'), (2, b'service'), (3, b'servicerole')], default=0
                ),
            ),
            ('lft', models.PositiveIntegerField(db_index=True, editable=False)),
            ('rght', models.PositiveIntegerField(db_index=True, editable=False)),
            ('tree_id', models.PositiveIntegerField(db_index=True, editable=False)),
            ('level', models.PositiveIntegerField(db_index=True, editable=False)),
            (
                'department',
                models.OneToOneField(
                    blank=True, null=True, to='intranet.Department', on_delete=models.CASCADE
                ),
            ),
            ('externals_count', models.PositiveIntegerField(default=0)),
            ('yandex_count', models.PositiveIntegerField(default=0)),
            ('yamoney_count', models.PositiveIntegerField(default=0)),
        ],
        options={
            'abstract': False,
            'db_table': 'intranet_group',
        },
    ),
    migrations.AddField(
        model_name='group',
        name='parent',
        field=models.ForeignKey(
            blank=True,
            null=True,
            related_name='children',
            to='intranet.Group',
            on_delete=models.CASCADE,
        ),
    ),
    migrations.AlterUniqueTogether(
        name='group',
        unique_together=set([('parent', 'role_scope_id')]),
    ),
    migrations.CreateModel(
        name='GroupMembership',
        fields=[
            ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ('joined_at', models.DateTimeField(auto_now_add=True)),
            ('group', models.ForeignKey(to='intranet.Group', on_delete=models.CASCADE)),
            ('staff', models.ForeignKey(to='intranet.Staff', on_delete=models.CASCADE)),
        ],
        options={
            'db_table': 'intranet_groupmembership',
        },
    ),
    migrations.AlterUniqueTogether(
        name='groupmembership',
        unique_together=set([('staff', 'group')]),
    ),
    migrations.AddField(
        model_name='group',
        name='members',
        field=models.ManyToManyField(related_name='in_groups', through='intranet.GroupMembership', to='intranet.Staff'),
    ),
    migrations.AlterModelManagers(
        name='group',
        managers=[
            ('tree', django.db.models.manager.Manager()),
        ],
    ),
]

OPERATIONS = operations_b2b if settings.IS_BUSINESS else operations_intranet


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ('auth', '0007_alter_validators_add_error_messages'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = OPERATIONS
