
from django.db import models

from wiki.intranet.models.base import IntranetModel
from wiki.intranet.models.color import ColoredModel
from wiki.intranet.models.position import SortedModel


class City(IntranetModel, ColoredModel, SortedModel):
    name = models.CharField(max_length=100)
    name_en = models.CharField(max_length=100, default='', blank=True)
    geo_id = models.IntegerField(default=0)
    country = models.ForeignKey('intranet.Country', null=True, blank=True, on_delete=models.CASCADE)

    def __str__(self):
        return self.name

    class Meta(IntranetModel.Meta):
        db_table = 'intranet_city'
