from enum import Enum

from django.utils.translation import ugettext_lazy as _

from wiki.legacy.choices import OrderedChoices

DOMAIN = OrderedChoices(
    ('AUTO_RU', 'A', 'auto.ru'),
    ('COMPTEK_RU', 'C', 'comptek.ru'),
    ('YANDEX_TEAM_RU', 'Y', 'yandex-team.ru'),
    ('YANDEX_TEAM_COM_UA', 'U', 'yandex-team.com.ua'),
    ('YAMONEY_RU', 'M', 'yamoney.ru'),
    ('YAPROBKI_RU', 'P', 'yaprobki.ru'),
    ('YANDEX_TEAM_COM', 'W', 'yandex-team.com'),
    ('YANDEX_TEAM_COM_TR', 'T', 'yandex-team.com.tr'),
)
GENDER = OrderedChoices(
    ('MALE', 'M', _('intranet_stuff.Staff_Male')),
    ('FEMALE', 'F', _('intranet_stuff.Staff_Female')),
)
FAMILY_STATUS = OrderedChoices(
    ('SINGLE', 'S', _('intranet_stuff.Staff_SingleMale')),
    ('MARRIED', 'M', _('intranet_stuff.Staff_MarriedMale')),
)
EDU_STATUS = OrderedChoices(
    ('SECONDARY', 'S', _('intranet_stuff.Staff_SecondaryEducation')),
    ('INCOMPLETE', 'I', _('intranet_stuff.Staff_HigherIncompleteEducation')),
    ('BACHELOR', 'B', _('intranet_stuff.Staff_BachelorsDegreeEducation')),
    ('MASTER', 'M', _('intranet_stuff.Staff_MastersDegreeEducation')),
    ('SPECIALIST', 'P', _('intranet_stuff.Staff_SpecialistDegreeEducation')),
    ('ACADEMIC', 'D', _('intranet_stuff.Staff_AcademicDegreeEducation')),
)
EDU_DIRECTION = OrderedChoices(
    ('TECHNICAL', 'T', _('intranet_stuff.Staff_TechnicalDirection')),
    ('LIBERAL', 'L', _('intranet_stuff.Staff_LiberalDirection')),
    ('NATURAL', 'N', _('intranet_stuff.Staff_NaturalDirection')),
    ('ECONOMIC', 'E', _('intranet_stuff.Staff_EconomicDirection')),
    ('BUSINESS', 'B', _('intranet_stuff.Staff_BusinessDirection')),
)
EMPLOYMENT = OrderedChoices(
    ('FULL', 'F', _('intranet_stuff.Staff_FullEmployment')),
    ('PARTIAL', 'P', _('intranet_stuff.Staff_PartTimeEmployment')),
    ('SECONDARY', 'D', _('intranet_stuff.Staff_SecondaryJob')),
)
LANG = OrderedChoices(
    ('EN', 'en', 'English'),
    ('RU', 'ru', 'Russian'),
    ('TR', 'tr', 'Turkish'),
)
TSHIRT_SIZE = OrderedChoices(
    ('XXS', 'XXS', 'XXS'),
    ('XS', 'XS', 'XS'),
    ('S', 'S', 'S'),
    ('M', 'M', 'M'),
    ('L', 'L', 'L'),
    ('XL', 'XL', 'XL'),
    ('XXL', 'XXL', 'XXL'),
    ('XXXL', 'XXXL', 'XXXL'),
)
AFFILIATION = OrderedChoices(
    ('YANDEX', 'yandex', _('intranet_stuff.Staff_AffiliationYandex')),
    ('YAMONEY', 'yamoney', _('intranet_stuff.Staff_AffiliationYamoney')),
    ('EXTERNAL', 'external', _('intranet_stuff.Staff_AffiliationExternal')),
)
GROUP_TYPE_CHOICES = OrderedChoices(
    ('WIKI', 0, 'wiki'),
    ('DEPARTMENT', 1, 'department'),
    ('SERVICE', 2, 'service'),
    ('SERVICEROLE', 3, 'servicerole'),
)


class GroupType(str, Enum):
    WIKI = 'wiki'
    SERVICE = 'service'
    SERVICEROLE = 'servicerole'

    GROUP = 'group'
    DEPARTMENT = 'department'


GROUP_TYPE_CHOICES_TO_ENUM = {
    0: GroupType.WIKI,
    1: GroupType.DEPARTMENT,
    2: GroupType.SERVICE,
    3: GroupType.SERVICEROLE,
}

CONNECT_GROUP_TYPE_TO_ENUM = {
    0: GroupType.GROUP,
    1: GroupType.DEPARTMENT,
}

SERVICEROLE_GROUP_TYPES = (
    ('adm', 'Админы (%s)'),
    ('dev', 'Разработчики (%s)'),
    ('pm', 'Менеджеры (%s)'),
    ('test', 'Тестирование (%s)'),
    ('support', 'Саппорт (%s)'),
    ('users', 'Другие (%s)'),
)
DEPARTMENT_ROLES = OrderedChoices(
    ('CHIEF', 'C', _('intranet_stuff.Department_chief')),
    ('DEPUTY', 'D', _('intranet_stuff.Department_deputy')),
)
