
from django.db import models

from wiki.intranet.models.base import IntranetModel
from wiki.intranet.models.color import ColoredModel
from wiki.intranet.models.position import SortedModel


class Country(IntranetModel, ColoredModel, SortedModel):
    name = models.CharField(max_length=100)
    name_en = models.CharField(max_length=100)
    yandex_domain = models.CharField(max_length=100)
    code = models.CharField(max_length=2, default='', blank=True)
    geo_base_id = models.IntegerField()

    def __str__(self):
        return self.name

    class Meta(IntranetModel.Meta):
        db_table = 'intranet_country'
