import warnings

from wiki.intranet.models.base import IntranetMpttModel
from wiki.intranet.models.consts import DEPARTMENT_ROLES
from wiki.intranet.models.position import SortedModel
from django.db import models


class Department(IntranetMpttModel, SortedModel):
    class Meta(IntranetMpttModel.Meta):
        db_table = 'intranet_department'

    class MPTTMeta:
        order_insertion_by = ['position']

    from_staff_id = models.PositiveIntegerField(db_index=True)
    parent = models.ForeignKey('self', null=True, blank=True, related_name='children', on_delete=models.CASCADE)
    kind = models.ForeignKey('intranet.DepartmentKind', null=True, on_delete=models.CASCADE)

    name = models.CharField(max_length=255)
    en_name = models.CharField(max_length=255, default='')
    name_en = models.CharField(max_length=255, default='')
    short_name = models.CharField(max_length=255, default='')
    short_name_en = models.CharField(max_length=255, default='')

    code = models.CharField(max_length=20, default='')
    url = models.CharField(max_length=255, default='', unique=True)
    dynamic_url = models.CharField(max_length=255, null=True, unique=True)
    bg_color = models.CharField(max_length=20, default='')
    fg_color = models.CharField(max_length=20, default='')

    maillists = models.CharField(max_length=4096, default='')
    clubs = models.CharField(max_length=4096, default='')
    wiki_page = models.CharField(max_length=2048, default='')
    jira_project = models.CharField(max_length=255, default='')
    description = models.CharField(max_length=4096, default='')
    description_en = models.CharField(max_length=4096, default='')

    @property
    def group_set(self):
        warnings.warn('`group_set` attribute is deprecated in favor to `group`.', DeprecationWarning)
        from wiki.intranet.models.group import Group

        return Group.objects.filter(department__id=self.id)

    def __str__(self):
        return self.name

    @property
    def chief(self):
        try:
            return self.departmentstaff_set.select_related('staff').filter(role=DEPARTMENT_ROLES.CHIEF)[0].staff
        except IndexError:
            return None

    @property
    def deputy(self):
        try:
            return self.departmentstaff_set.select_related('staff').filter(role=DEPARTMENT_ROLES.DEPUTY)[0].staff
        except IndexError:
            return None
