from django.db import models
from wiki.intranet.models.base import IntranetModel


class DepartmentKind(IntranetModel):
    class Meta(IntranetModel.Meta):
        db_table = 'intranet_department_kind'

    name = models.CharField(max_length=64)
    name_en = models.CharField(max_length=64, blank=True)
    rank = models.IntegerField(default=0)
    slug = models.CharField(
        max_length=64,
        null=True,
        unique=True,
    )

    def __str__(self):
        return '%s %s' % (self.slug or '', self.rank)
