
from django.db import models

from wiki.intranet.models.consts import DEPARTMENT_ROLES


class DepartmentStaff(models.Model):
    department = models.ForeignKey('intranet.Department', null=True, on_delete=models.CASCADE)
    staff = models.ForeignKey('intranet.Staff', null=True, on_delete=models.CASCADE)
    role = models.CharField(max_length=1, choices=DEPARTMENT_ROLES.choices())

    def __str__(self):
        return '%s is %s in %s' % (self.staff.login, self.role, str(self.department))

    class Meta:
        db_table = 'intranet_departmentstaff'
        app_label = 'intranet'


class DepartmentStaffCounter(models.Model):
    department = models.ForeignKey('intranet.Department', null=False, on_delete=models.CASCADE)
    day = models.DateField(db_index=True)
    staff_counter = models.PositiveSmallIntegerField()

    def __str__(self):
        return '%s at %s: %d' % (self.department.name, self.day, self.staff_counter)

    class Meta:
        db_table = 'intranet_departmentstaffcounter'
        unique_together = (('department', 'day'),)
        app_label = 'intranet'
