
from warnings import warn

from wiki.intranet.models.consts import GENDER


class Inflection(object):
    forms = {
        'subjective': 1,
        'genitive': 2,
        'dative': 3,
        'accusative': 4,
        'ablative': 5,
        'prepositional': 6,
    }

    def __init__(self, target):
        self.target = target
        super(Inflection, self).__init__()

    def inflect(self, form_name):
        if form_name in self.forms:
            return self._inflect(self.forms[form_name])
        else:
            raise AttributeError('Unknown inflection form')

    def inflection(self, form_id):
        warn('Deprecated method, use staff.inflections.inflect')
        return self._inflect(form_id)

    def _inflect(self, form_id):
        if isinstance(self.target, str):
            return self.inflect_text(form_id)
        else:
            return self.inflect_staff(form_id)

    def inflect_staff(self, form_id):
        from wiki.legacy import metainflect as inflect

        return inflect.inflect_fio(
            first_name=self.target.i_first_name,
            last_name=self.target.i_last_name,
            form_id=form_id,
            gender=getattr(self.target, 'gender', GENDER.MALE),
        )

    def inflect_text(self, form_id):
        """
        Перевод фамилии и имени пользователя, переданных в виде входного текстового параметра.
        Этот способ перевода устарел. Перевод должен вызываться через staff объект.

        @todo: удалить метод, если его никто уже не использует
        """
        from wiki.legacy import metainflect as inflect

        target = self.target
        is_brace = target.find('(') != -1
        is_minus = target.find('-') != -1

        if is_brace or is_minus:
            return self.inflect_double(target, form_id, '(' if is_brace else '-')
        else:
            return inflect.inflect(target, form_id, True) or target

    def inflect_double(self, target, form_id, delimiter='('):
        """Просклонять составное имя или фамилию.

        @param target: unicode строка
        @return: unicode
        """
        from wiki.legacy import metainflect as inflect

        invert_delimiter = ')' if delimiter == '(' else ''
        before_delimiter, after_delimiter = list(map(str.strip, target.split(delimiter, 1)))
        if invert_delimiter:
            after_delimiter = after_delimiter.strip(invert_delimiter)
        after_delimiter = after_delimiter.strip()

        before_paren_inf = inflect.inflect(before_delimiter, form_id, True)
        if before_paren_inf:
            before_delimiter = before_paren_inf

        after_paren_inf = inflect.inflect(after_delimiter, form_id, True)
        if after_paren_inf:
            after_delimiter = after_paren_inf

        return ''.join(
            (before_delimiter, ' ' if delimiter == '(' else '', delimiter, after_delimiter, invert_delimiter)
        )

    def __iter__(self):
        yield self.subjective
        yield self.genitive
        yield self.dative
        yield self.accusative
        yield self.ablative
        yield self.prepositional

    def __str__(self):
        return ', '.join([x for x in self])

    def __getattr__(self, attr_name):
        return self.inflect(attr_name)


class StaffInflection(Inflection):
    def inflection(self, form_id):
        return super(StaffInflection, self).inflection(form_id)

    def __init__(self, staff):
        self.staff = staff
        super(StaffInflection, self).__init__(staff)

    def __len__(self):
        return 1

    # NOTE: need to remove this method when all guys around the world
    # will use staff.inflections AS OBJECT, not as one-element list
    def __getitem__(self, key):
        if isinstance(key, int):
            return self
        else:
            return super(StaffInflection, self).__getitem__(key)
