
from django.db import models

from wiki.intranet.models.base import IntranetModel
from wiki.intranet.models.position import SortedModel


class Office(IntranetModel, SortedModel):
    from_staff_id = models.PositiveIntegerField(db_index=True)
    name = models.CharField(max_length=255)
    name_en = models.CharField(max_length=255, default='')
    city = models.ForeignKey('intranet.City', null=True, blank=True, on_delete=models.CASCADE)
    color = models.CharField(max_length=10)
    have_map = models.BooleanField(default=False)
    coord_x = models.FloatField(null=True)
    coord_y = models.FloatField(null=True)
    zoom = models.PositiveSmallIntegerField(default=0)
    address1 = models.CharField(max_length=255, default='')
    address2 = models.CharField(max_length=255, default='')
    address1_en = models.CharField(max_length=255, default='')
    address2_en = models.CharField(max_length=255, default='')
    phone = models.CharField(max_length=50, default='')
    fax = models.CharField(max_length=50, default='')
    code = models.CharField(max_length=20, default='')
    tz = models.CharField(max_length=20, default='')
    filter_id = models.CharField(max_length=40, default='', blank=True)

    def __str__(self):
        return self.name

    @property
    def short_name(self):
        i_name = self.i_name
        pos = i_name.find(', ')
        if pos != -1:
            return i_name[pos + 2 :]
        return self.i_name

    class Meta(IntranetModel.Meta):
        db_table = 'intranet_office'
