import warnings

from django.db import models
from django.utils.translation import ugettext_lazy as _

from wiki.legacy.choices import OrderedChoices

from wiki.intranet.models.base import IntranetModel, IntranetMpttModel


class Service(IntranetMpttModel):
    from_staff_id = models.PositiveIntegerField(db_index=True, editable=False)
    parent = models.ForeignKey(
        'Service',
        null=True,
        blank=True,
        related_name='children',
        verbose_name=_('intranet_stuff.Service.parent'),
        on_delete=models.CASCADE,
    )
    jira_key = models.CharField(
        max_length=20, default='', blank=True, verbose_name=_('intranet_stuff.Service.jira_key')
    )
    name = models.CharField(max_length=255, verbose_name=_('intranet_stuff.Service.name'))
    description = models.TextField(default='', blank=True, verbose_name=_('intranet_stuff.Service.description'))
    url = models.CharField(max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.Service.url'))
    url_wiki = models.CharField(
        max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.Service.url_wiki')
    )
    wiki_supertag = models.CharField(
        max_length=255, db_index=True, default='', blank=True, verbose_name=_('intranet_stuff.Service.wiki_supertag')
    )
    url_statface = models.CharField(
        max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.Service.url_statface')
    )
    url_monitoring = models.CharField(
        max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.Service.url_monitoring')
    )
    url_ya_clubs = models.CharField(
        max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.Service.url_ya_clubs')
    )
    url_at_clubs = models.CharField(
        max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.Service.url_at_clubs')
    )
    url_vcs = models.CharField(max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.Service.url_vcs'))
    url_beta = models.CharField(
        max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.Service.url_beta')
    )
    url1 = models.CharField(max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.Service.url1'))
    url1_title = models.CharField(
        max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.Service.url1_title')
    )
    url2 = models.CharField(max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.Service.url2'))
    url2_title = models.CharField(
        max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.Service.url2_title')
    )
    url3 = models.CharField(max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.Service.url3'))
    url3_title = models.CharField(
        max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.Service.url3_title')
    )
    url4 = models.CharField(max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.Service.url4'))
    url4_title = models.CharField(
        max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.Service.url4_title')
    )
    url_help = models.CharField(
        max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.Service.url_help')
    )
    maillist = models.EmailField(null=True, default='', blank=True, verbose_name=_('intranet_stuff.Service.maillist'))
    metrika_id = models.PositiveIntegerField(null=True, blank=True, verbose_name=_('intranet_stuff.Service.metrika_id'))
    keywords = models.TextField(default='', blank=True, verbose_name=_('intranet_stuff.Service.keywords'))
    position = models.IntegerField(db_index=True, default=0, editable=False)
    owner = models.ForeignKey(
        'intranet.Staff',
        null=True,
        blank=True,
        verbose_name=_('intranet_stuff.Service.owner'),
        on_delete=models.CASCADE,
    )

    @property
    def group_set(self):
        warnings.warn('`group_set` attribute is deprecated in favor to `group`.', DeprecationWarning)
        from wiki.intranet.models.group import Group

        return Group.objects.filter(service__id=self.id)

    @property
    def maillist_name(self):
        if self.maillist:
            splitted = self.maillist.split('@')
            if len(splitted) == 2:
                name, domain = splitted
                if domain != 'yandex-team.ru':
                    return self.maillist
                else:
                    return name
            elif len(splitted) == 1:
                return self.maillist

    def __str__(self):
        return self.name

    class Meta(IntranetMpttModel.Meta):
        db_table = 'intranet_service'


class ServiceRole(IntranetModel):
    from_staff_id = models.PositiveIntegerField(db_index=True, editable=False)
    name = models.CharField(max_length=255, default='', verbose_name=_('intranet_stuff.ServiceRole.name'))
    position = models.IntegerField(db_index=True, verbose_name=_('intranet_stuff.ServiceRole.position'))
    senior = models.BooleanField(default=False, verbose_name=_('intranet_stuff.ServiceRole.senior'))

    def __str__(self):
        return self.name

    class Meta(IntranetModel.Meta):
        db_table = 'intranet_servicerole'


class ServiceMember(models.Model):
    OCCUPANCY = OrderedChoices(
        ('FULL', 8, _('intranet_stuff.ServiceMember_full')),
        ('PARTIAL', 4, _('intranet_stuff.ServiceMember_partial')),
        ('SLIGHTLY', 1, _('intranet_stuff.ServiceMember_slightly')),
    )
    from_staff_id = models.PositiveIntegerField(db_index=True)
    staff = models.ForeignKey(
        'intranet.Staff', on_delete=models.CASCADE, verbose_name=_('intranet_stuff.ServiceMember.staff')
    )
    service = models.ForeignKey(
        Service, on_delete=models.CASCADE, verbose_name=_('intranet_stuff.ServiceMember.service')
    )
    role = models.ForeignKey(ServiceRole, verbose_name=_('intranet_stuff.ServiceMember.role'), on_delete=models.CASCADE)
    custom_role = models.CharField(
        max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.ServiceMember.custom_role')
    )
    description = models.CharField(
        max_length=255, default='', blank=True, verbose_name=_('intranet_stuff.ServiceMember.description')
    )
    position = models.IntegerField(db_index=True, editable=False, default=0)
    is_temp = models.BooleanField(default=False, verbose_name=_('intranet_stuff.ServiceMember.is_temp'))
    occupancy = models.PositiveSmallIntegerField(
        choices=OCCUPANCY.choices(), default=0, blank=True, verbose_name=_('intranet_stuff.ServiceMember.occupancy')
    )
    weight = models.FloatField(default=0, blank=True, verbose_name=_('intranet_stuff.ServiceMember.weight'))

    def __str__(self):
        return '%s is %s in %s' % (str(self.staff), str(self.role), str(self.service))

    class Meta:
        db_table = 'intranet_servicemember'
        app_label = 'intranet'
