
from django import template
from django.conf import settings

register = template.Library()


def _lego_version():
    return getattr(settings, 'LEGO_VERSION', '2.6')  # дефолтное значение


@register.inclusion_tag('b-lang-switcher.html', takes_context=True)
def b_lang_switcher(
    context,
    lego_version=None,
):
    'Вставляет лего-блок переключения языка локали'

    if lego_version is None:
        lego_version = _lego_version()

    path_to_template = 'lego-%s/b-lang-switcher.html' % lego_version

    switch_url = getattr(settings, 'LANG_SWITCH_URL', '/?lang=')

    return {
        'template': path_to_template,
        'request': context['request'],
        'switch_url': switch_url,
    }


@register.inclusion_tag('b-foot.html', takes_context=True)
def b_foot(context, about_url='', lego_version=None):
    """ Вставляет стандартный интранет-футер с переключалкой языка """

    if lego_version is None:
        lego_version = _lego_version()

    path_to_template = 'lego-%s/b-foot.html' % lego_version

    return {
        'template': path_to_template,
        'request': context['request'],
        'about_url': about_url,
    }
