
ENV_DEVELOPMENT = 'development'
ENV_TESTING = 'testing'
ENV_PRODUCTION = 'production'


def get_environment_type():
    try:
        try:
            return open('/etc/yandex/environment.type').readline().strip()
        except IOError:
            return open('/etc/yandex/environment').readline().strip()
    except IOError:
        return ENV_DEVELOPMENT


# @TODO: make deprecated
def get_environment(default=ENV_DEVELOPMENT):
    return get_environment_type()


environment_type = get_environment_type()


def get_environment_name():
    """
    Reads /etc/yandex/environment.name and returns current environment name.
    """
    try:
        return open('/etc/yandex/environment.name').readline().strip()
    except IOError:
        return None


def environment_context(request):
    """
    Context processor that adds to context 'env' variable with current
    environment type and all available type constants.
    """
    return {
        'env': get_environment(),
        'ENV_DEVELOPMENT': ENV_DEVELOPMENT,
        'ENV_TESTING    ': ENV_TESTING,
        'ENV_PRODUCTION': ENV_PRODUCTION,
    }
