# http://wiki.yandex-team.ru/WackoWiki/dev/django/formatters

from django.template import Template

from wiki.legacy.formatters.templates import TEMPLATES


class BaseFormatter(object):
    """Base class for all formatters in wiki"""

    _templates = {}

    default_params = None

    def __init__(self, params=None, **kwargs):
        self.params = {}
        self.ordered_params = []
        if self.default_params:
            self.params.update(self.default_params)
        self.update_from_params(params)
        for key, value in kwargs.items():
            setattr(self, key, value)

    def format(self, text):
        return text

    def _parse_wf_params(self, params):
        if params.dict:
            self.params.update(params.dict)
        if params.list:
            self.ordered_params.extend(p[1] for p in params.list)

    def update_from_params(self, params):
        if params and hasattr(params, 'dict'):
            self._parse_wf_params(params)
        elif isinstance(params, list):
            self.ordered_params.extend(params)
        elif params:
            self.params.update(params)

    def bool_param(self, param_name):
        if param_name in self.ordered_params:
            return True
        if param_name in self.params:
            return self.params[param_name] in ['1', 'yes', 'on', 'true', True]
        return False

    def get_template(self, template_filename):
        template = self._templates.get(template_filename)
        if template is None:
            template = Template(read_template_file(template_filename), name=template_filename)
            self._templates[template_filename] = template
        return template


def read_template_file(filename):
    try:
        return TEMPLATES[filename.lower()]
    except KeyError:
        raise FileNotFoundError
