from wiki.legacy.formatters.base_graph import BaseGraphFormatter
from wiki.utils.errors import InputValidationError

STDERR_ERROR_PREFIX = 'Error: <stdin>:'
STDERR_ERROR_PREFIX_LENGTH = len(STDERR_ERROR_PREFIX)


class Graphviz(BaseGraphFormatter):
    tools = ['dot', 'neato', 'circo', 'twopi', 'fdp']

    def parse_stderr_from_tool(self, stderr):
        """
        Форматтер может вернуть строку
        Error: <stdin>:0: syntax error near line 0

        (с переводом строки на конце). Это ошибка синтаксиса.

        @type stderr: str
        """
        if isinstance(stderr, bytes):
            stderr = stderr.decode('utf-8')

        if stderr.startswith(STDERR_ERROR_PREFIX):
            raise InputValidationError(stderr[stderr.find(':', STDERR_ERROR_PREFIX_LENGTH) + 2 :].rstrip())
