CODE_HELP = """<div class="b-page-code-help g-js" onclick="return {name: 'b-page-code-help'}">
    <p class="b-page-code-help__languages"></p>
</div>"""

CODE = """{% if inline %}
    <span class="b-page-code b-page-code_inline_yes i-bem" data-bem='{"b-page-code": {}}'>
        <code class="b-page-code__code {{ language|default:"" }}">{{ text }}</code>
    </span>
{% else %}
    <div class="b-page-code b-page-code_multiline_yes i-bem" data-bem='{"b-page-code": {}}'>
        {% if show_line_numbers and language != 'no-highlight' %}
            <code class="b-page-code__line-numbers {{ language|default:"" }}" style="display: none;">
                {% for line_number in line_numbers %}
                    <span class="b-page-code__line-number">{{ line_number }}</span>
                {% endfor %}
            </code>
        {% else  %}
            <code class="b-page-code__empty-line-numbers"></code><!-- fix for windows webkit -->
        {% endif %}
        <code class="b-page-code__code {{ language|default:"" }}" style="white-space: pre;">{{ text }}</code>
    </div>
{% endif %}
"""

GRAPH_ERROR = """{% for error in errors %}
        <div class="error">{{ error }}</div>
{% endfor %}
"""

TEMPLATES = {
    'code.html': CODE,
    'code_help.html': CODE_HELP,
    'graph/error.html': GRAPH_ERROR,
}
