from dataclasses import dataclass
from django.conf import settings
from typing import Optional


@dataclass
class Config:
    formatters: set[str]
    actions_packages: tuple
    actions: set[str]
    action_aliases: set[str]
    use_http_proxy: bool
    http_proxy: Optional[str]


WIKI_FORMATTERS = {
    'graphviz',  # используется в ручке, которая рендерит диаграммы для щщи
    'blockdiag',  # используется в ручке, которая рендерит диаграммы для щщи
    'seqdiag',  # используется в ручке, которая рендерит диаграммы для щщи
}

WIKI_ACTIONS_PACKAGES = ('wiki.actions.classes',)

WIKI_ACTIONS = {
    # Списки страниц
    'backlinks',
    'tree',
    # Персональные действия
    'mypages',
    'pages',  # Синоним mypages
    'mywatches',
    # Прочие
    'toc',
}

if settings.IS_INTRANET:
    # Интранет-специфичные экшены
    WIKI_ACTIONS |= {
        'serviceteam'
    }

ACTION_ALIASES = {
    'a': 'anchor',
    'pages': 'mypages',
}

USE_HTTP_PROXY = settings.IS_BUSINESS

config = Config(
    formatters=WIKI_FORMATTERS,
    actions_packages=WIKI_ACTIONS_PACKAGES,
    actions=WIKI_ACTIONS,
    action_aliases=ACTION_ALIASES,
    use_http_proxy=USE_HTTP_PROXY,
    http_proxy='http://{user}:{tvm}@go.zora.yandex.net:1080',
)
