
# http://djangosnippets.org/snippets/1478/
from django.db import models
from wiki.legacy.json import CustomJSONEncoder, loads, dumps


class JSONField(models.TextField):
    """JSONField is a generic textfield that neatly serializes/unserializes
    JSON objects seamlessly"""

    def from_db_value(self, value, expression, connection, context):
        if value is None:
            return value
        return loads(value)

    def to_python(self, value):
        """Convert our string value to JSON after we load it from the DB"""
        if value == '':
            return None

        if isinstance(value, str):
            return loads(value)

        return value

    def get_db_prep_value(self, value, connection, prepared=False):
        """Convert our JSON object to a string before we save"""
        if prepared:
            return value
        if value is None:
            value = '{}'
        else:
            value = dumps(value, cls=CustomJSONEncoder)
        return value
