
from django.conf import settings
from django.utils import translation


def _lang():
    lang = translation.get_language() or settings.LANGUAGE_CODE
    return lang.split('-')[0]


def html_quotation(s):
    if _lang() == 'ru':
        format_str = '«%s»'
    else:
        format_str = '“%s”'
    return format_str % str(s)
