# !!!! Выпилить всех кто это использует -- оно не взлетит для постгри !!!!

import warnings

from django.db import connection
from django.conf import settings

# First, work out if we're multi-db or not, and which databases we have

try:
    from django.db import DEFAULT_DB_ALIAS
except ImportError:
    # 1.1 or below
    db_engine = settings.DATABASE_ENGINE
else:
    # 1.2 or above
    db_engine = settings.DATABASES[DEFAULT_DB_ALIAS]['ENGINE']

if '.' in db_engine:
    db_engine = db_engine.rsplit('.', 1)[1]


def is_slave_oracle(cursor):
    sql = 'SELECT open_mode FROM v$database'
    cursor.execute(sql)
    return cursor.fetchone()[0] == 'READ ONLY'


def is_slave_mysql(cursor):
    sql = 'SELECT @@read_only'
    cursor.execute(sql)
    return int(cursor.fetchone()[0])


def is_slave_default(cursor):
    warnings.warn('is_slave() is not implemented for your DB engine (%s)' % db_engine)
    return False


def is_slave():
    return _is_slave(connection.cursor()) or getattr(settings, 'READ_ONLY', False)


_slave_checkers = {
    'oracle': is_slave_oracle,
    'mysql': is_slave_mysql,
}

custom_is_slave_checkers = getattr(settings, 'CUSTOM_IS_SLAVE_CHECKERS', {})
_slave_checkers.update(custom_is_slave_checkers)
_is_slave = _slave_checkers.get(db_engine, is_slave_default)
