from wiki.utils.supertag import translit


class Url:
    @classmethod
    def translit(cls, word, to_lower=True):
        translited = translit(word, to_lower)
        return translited.lower() if to_lower else translited

    @staticmethod
    def get_ancestors(url):
        _url = url.strip('/')
        ancestors = []
        while _url.rfind('/') != -1:
            _url = _url[: _url.rfind('/')]
            ancestors.append(_url)
        return ancestors


# for backward compatibility
# @todo: need refactoring for change class name
Uri = Url
