import pickle
from io import BytesIO


class WfCompatUnpickler(pickle.Unpickler):
    """
    Так как в старом форматтере были запиклены деревья, после внесения модуля в wiki
    анпикл падает с ImportError
    wf ->  wiki.legacy.wf
    """

    def find_class(self, module, name):
        if module.startswith('wf'):
            module = 'wiki.legacy.' + module
        return super().find_class(module, name)


def compat_pickle_loads(bytecode):
    if isinstance(bytecode, str):
        bytecode = bytecode.encode()

    return WfCompatUnpickler(BytesIO(bytecode)).load()


def compat_pickle_load(stream):
    return WfCompatUnpickler(stream).load()
