#!/usr/bin/env python
# flake8: noqa

import sys
from os import environ, path

from django.core.management import execute_from_command_line
from dotenv import load_dotenv

from wiki.env import set_env_type

# ---- пропатчить переменные среды нужно до всех импортов из wiki.*

cur_path = path.abspath(path.join(path.dirname(__file__), '..'))
sys.path.insert(0, cur_path)
if path.join(cur_path, 'wiki') in sys.path:
    sys.path.remove(path.join(cur_path, 'wiki'))

# ---- подгрузим из .env, если есть
load_dotenv('./env/.env')

set_env_type()

environ.setdefault('DJANGO_SETTINGS_MODULE', 'wiki.settings')


def management():
    execute_from_command_line(sys.argv)


def celery():
    from celery.bin.celery import main

    argv = sys.argv
    task_queues = environ.get('CELERY_QUEUES')
    if task_queues:
        argv.extend(['-Q', task_queues])
    return main(argv)


if __name__ == '__main__':
    execute_from_command_line(sys.argv)
