from django.conf import settings
from django.utils import translation
from django.utils.cache import patch_vary_headers
from django.utils.deprecation import MiddlewareMixin
from wiki.intranet.models import Staff


class LocaleMiddleware(MiddlewareMixin):
    """
    Прокси для миддлвари определения языка.
    """

    def process_request(self, request):
        # LANGUAGE_CODE может быть выставлено другим middleware, например,
        # wiki.middleware.passport_auth.PassportAuthMiddleware может получить его из блекбокса
        language = getattr(request, 'LANGUAGE_CODE', None)

        if not language and request.user.is_authenticated:
            try:
                language = request.user.staff.lang_ui
            except Staff.DoesNotExist:
                pass

        if language not in [code for code, name in settings.LANGUAGES]:
            language = settings.LANGUAGES[0][0]  # Использовать дефолтный язык

        translation.activate(language)
        request.LANGUAGE_CODE = translation.get_language()

    def process_response(self, request, response):
        patch_vary_headers(response, ('Accept-Language',))
        if 'Content-Language' not in response:
            response['Content-Language'] = translation.get_language()
        translation.deactivate()
        return response
