from django.middleware.csrf import CsrfViewMiddleware


skip_csrf_on = ('/.explainlinks.json', '/.upload.json')


class WikiSpecialCSRFMiddleware(CsrfViewMiddleware):

    """По вызванному хендлеру позволяет выключить CSRF защиту. Это для флешового загрузчика файлов"""

    def __skip_csrf(self, request, callback):
        if request.META['PATH_INFO']:
            if any(request.META['PATH_INFO'].endswith(_) for _ in skip_csrf_on):
                return True
        return False

    def process_view(self, request, callback, callback_args, callback_kwargs):
        if self.__skip_csrf(request, callback):
            request.csrf_processing_done = True
            return None
        return CsrfViewMiddleware.process_view(self, request, callback, callback_args, callback_kwargs)
