
import logging

import pytz
from django.utils import timezone
from django.utils.deprecation import MiddlewareMixin

from wiki.utils.timezone import select_timezone

logger = logging.getLogger(__name__)


class TimezoneMiddleware(MiddlewareMixin):
    """
    Выбрать таймзону, в которой работает код.
    """

    def process_request(self, request):
        timezone.activate(pytz.timezone(select_timezone(request.user)))
