from django.conf import settings
from django.utils.deprecation import MiddlewareMixin
from wiki.legacy.env import environment_type
from ipaddr import IPAddress, IPv6Address


class YandexServerRecognize(MiddlewareMixin):
    def process_request(self, request):
        """Выставить флаг from_yandex_server в request

        Яндекс-сервер приходит с IP из списка YANDEX_SERVER_IPS и его user-agent содержит "yandex.server"
        """
        request.from_yandex_server = False
        ip_address = request.META.get('HTTP_X_REAL_IP', request.META['REMOTE_ADDR'])

        # Приводим маппинг IPv4 в IPv6 обратно в IPv4
        # Если запрос приходит с ::ffff:77.88.9.54, приводим его к 77.88.9.54
        wrapped_ip_address = IPAddress(ip_address)
        if isinstance(wrapped_ip_address, IPv6Address) and wrapped_ip_address.ipv4_mapped is not None:
            ip_address = wrapped_ip_address.ipv4_mapped.compressed

        user_agent = request.META.get('HTTP_USER_AGENT', '').lower()
        if (
            ip_address in settings.YANDEX_SERVER_IPS or environment_type != 'production'
        ) and 'yandex.server' in user_agent:
            request.from_yandex_server = True
