from enum import Enum
from typing import Dict


class WidgetTypes(Enum):
    # виджеты из контейнера ContainerTypes.WIDGETS
    MAIL = 'mail'
    WIKI = 'wiki'
    TRACKER = 'tracker'

    # виджеты из контейнера ContainerTypes.CONTENT
    SERVICE_LIST = 'service_list'
    IMPORTANT_INFO = 'important_info'
    ABOUT_COMPANY = 'about_company'
    YANDEX_MAGAZINE = 'yandex_magazine'
    OFFICES = 'offices'
    CONTACTS = 'contacts'
    ATUSHKA_TOP = 'atushka_top'

    @classmethod
    def has_value(cls, value):
        return value in cls._value2member_map_


class ContainerTypes(Enum):
    WIDGETS = 'widgets'
    CONTENT = 'content'


CONTENT_WIDGET_ORDERING: Dict[WidgetTypes, int] = {
    WidgetTypes.SERVICE_LIST: 1,
    WidgetTypes.IMPORTANT_INFO: 2,
    WidgetTypes.ABOUT_COMPANY: 3,
    WidgetTypes.YANDEX_MAGAZINE: 4,
    WidgetTypes.OFFICES: 5,
    WidgetTypes.CONTACTS: 6,
    WidgetTypes.ATUSHKA_TOP: 7,
}


class BunkerNodeVersions(Enum):
    LATEST = 'latest'
    STABLE = 'stable'
