import enumfields.fields
from django.conf import settings
from django.db import migrations, models
from django.contrib.postgres.fields import JSONField

import wiki.morda.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Widget',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                (
                    'user',
                    models.ForeignKey(
                        related_name='widgets', to=settings.AUTH_USER_MODEL, on_delete=models.CASCADE
                    ),
                ),
                ('type', enumfields.fields.EnumField(enum=wiki.morda.consts.WidgetTypes, max_length=15)),
                (
                    'container_type',
                    enumfields.fields.EnumField(enum=wiki.morda.consts.ContainerTypes, max_length=10),
                ),
                ('order', models.PositiveSmallIntegerField(default=False, null=True)),
                ('is_visible', models.BooleanField(null=True)),
                ('custom_settings', JSONField(default={})),
            ],
        ),
    ]
