from django.contrib.postgres.fields import JSONField
from django.db import models
from django.conf import settings
from enumfields import EnumField

from wiki.morda.consts import WidgetTypes, ContainerTypes


class PersonalizedWidget(models.Model):
    # ссылка на пользователя (автора настроек виджета)
    user = models.ForeignKey(settings.AUTH_USER_MODEL, related_name='widgets', on_delete=models.CASCADE)

    # тип виджета
    type = EnumField(WidgetTypes, max_length=15)

    # тип контейнера, в котором находится виджет
    container_type = EnumField(ContainerTypes)

    # порядковый номер расположения виджета в блоке на странице
    order = models.PositiveSmallIntegerField(null=True)

    # пользовательская настройка признака отображения виджета на странице
    is_visible = models.BooleanField(default=False)

    # кастомные настройки виджета для конкретного пользователя
    custom_settings = JSONField(default=dict)

    class Meta:
        app_label = 'morda'
        db_table = 'morda_widget'
