import logging

from rest_framework import serializers

from wiki.morda.consts import WidgetTypes


logger = logging.getLogger(__name__)


class WidgetTypesListSerializer(serializers.Serializer):
    widget_types = serializers.ListField(child=serializers.CharField(min_length=1), required=False)
    ignore_cache = serializers.BooleanField(required=False)

    default_error_messages = {
        'unknown_widget_type': '{error}',
    }

    def validate(self, attrs):
        widget_types = attrs.get('widget_types')

        if widget_types:
            try:
                _ = [WidgetTypes(type) for type in widget_types]
            except ValueError as err:
                self.fail('unknown_widget_type', error=err)

        return attrs
