import logging

from rest_framework import serializers

from wiki.morda.widgets.service_list.widget import ServiceListWidget

logger = logging.getLogger(__name__)


class ServicesOrderingSerializer(serializers.Serializer):
    ordering = serializers.ListField(child=serializers.CharField(min_length=1))

    default_error_messages = {
        'ordering_required': 'Ordering parameter is required',
    }

    @property
    def user(self):
        return self.context['request'].user

    def validate(self, attrs):
        ordering = attrs.get('ordering')

        if not ordering:
            self.fail('ordering_required')

        return attrs

    def save(self):
        settings = ServiceListWidget.get_user_settings(self.user)
        settings.ordering = self.data.get('ordering')
        ServiceListWidget.save_user_settings(self.user, settings)
