from rest_framework.response import Response
from rest_framework.serializers import Serializer

from wiki.api_core.raises import raises
from wiki.morda.errors import JsonValidationError
from wiki.morda.views.base import MainPageAPIView


class WidgetsListView(MainPageAPIView):
    serializer_class = Serializer

    @raises(JsonValidationError)
    def get(self, request, *args, **kwargs):
        """
        Получить список всех виджетов, доступных текущему пользователю.

        %%
        curl -H "Authorization: OAuth <token>" "https://wiki-api.yandex-team.ru/_api/imain/widgets"
        %%

        Ответ
        %%(js)
        "data": {
            "widgets": [
                {
                    "type": "wiki",
                },
                {
                    "type": "tracker",
                },
                ...
            ]
        }
        %%
        """
        data = {}  # @TODO получить список виджетов из бункера

        # @TODO отфильтровать список виджетов в зависимости от роли пользователя
        for widget in data['widgets']:
            widget.pop('access_role')

        return Response(data)
