from pydantic import BaseModel
from typing import Dict, List, Union

from wiki.morda.widgets.base_entities import WidgetData, WidgetSettings


class ServiceData(BaseModel):
    id: str
    name: Dict[str, str]
    url: str
    icon: str

    @classmethod
    def from_dict(cls, data: Dict[str, Union[str, Dict[str, Dict[str, str]]]]):
        return cls(id=data['id'], name=data['name']['i18n'], url=data['url'], icon=data['icon'])


class ServiceListData(WidgetData):
    services: List[ServiceData]
    images: Dict[str, str]

    @classmethod
    def from_dict(cls, data: Dict[str, Dict[str, Union[str, Dict[str, List[ServiceData]]]]]):
        return cls(
            services=[ServiceData.from_dict(srv) for srv in data['content'].get('services', [])], images=data['images']
        )


class ServiceListSettings(WidgetSettings):
    ordering: List[str]

    @classmethod
    def from_dict(cls, data: Dict[str, List[str]]):
        return cls(ordering=data.get('ordering', []))
