from typing import Dict

from wiki.morda.consts import WidgetTypes, ContainerTypes
from wiki.morda.widgets.base_widget import BaseWidget
from wiki.users.models import User

from .entities import ServiceListData, ServiceListSettings


class ServiceListWidget(BaseWidget[ServiceListData, ServiceListSettings]):
    data_class = ServiceListData
    custom_settings_class = ServiceListSettings
    bunker_xpath = 'widgets_data/service_list'

    widget_type = WidgetTypes.SERVICE_LIST
    container_type = ContainerTypes.CONTENT

    @classmethod
    def response_builder(
        cls, data: data_class, settings: custom_settings_class, user: User, lang: str
    ) -> Dict[str, any]:

        for service in data.services:
            # замена названия картинок на ссылки в хранилище
            img_name = service.icon
            url = data.images.get(img_name)
            if url:
                service.icon = url

            # перевод имени сервиса
            service.name = service.name.get(lang, service.name.get('en'))

        ordering = cls.get_user_settings(user).ordering
        if ordering:
            # сортировка сервисов с учетом пользовательских настроек
            mapping = {service.id: service for service in data.services}
            links = [mapping.pop(id) for id in ordering if id in mapping]
            links.extend(mapping.values())
        else:
            links = data.services

        return {'data': {'links': links}, 'settings': settings}

    @classmethod
    def get_user_settings(cls, user: User) -> custom_settings_class:
        return cls.custom_settings_class.from_dict(cls.get_user_widget_settings(user=user))

    @classmethod
    def save_user_settings(cls, user: User, settings: custom_settings_class):
        cls.save_user_widget_settings(user=user, settings=settings)
