

import logging

from wiki.notifications.models import PageEvent

logger = logging.getLogger(__name__)

PAGE_EVENTS_WITH_REVISION = {
    PageEvent.EVENT_TYPES.create,
    PageEvent.EVENT_TYPES.edit,
}


def revision_by_page_event(page_event):
    """
    Вернуть ревизию по переданному PageEvent.

    @type page_event: PageEvent
    """
    from wiki.pages.models import Revision

    if page_event.event_type in PAGE_EVENTS_WITH_REVISION:
        try:
            revision_id = page_event.meta['revision_id']
        except KeyError:
            logger.warning('Page event object has no references to revision: %s', page_event)
            return None
        try:
            revision = Revision.objects.select_related('author').get(id=revision_id)
        except Revision.DoesNotExist:
            # такое возможно, если ревизий было слишком много у страницы и мы часть из них удалили
            # ради экономии места в MDS
            logger.warning('Revision for this Page event object does not exist: %s', page_event)
            return None

        return revision
    return None
