
from django.conf import settings

from wiki.notifications.generators.addcomment import AddCommentGen
from wiki.notifications.generators.addfile import AddFileGen
from wiki.notifications.generators.change_access import ChangeAccessGen
from wiki.notifications.generators.change_author import ChangeAuthorGen
from wiki.notifications.generators.creation import CreationGen
from wiki.notifications.generators.grid.edition import EditionGen as GridEdition
from wiki.notifications.generators.keywords import KeywordsGen
from wiki.notifications.generators.mark_actuality import MarkActualityGen
from wiki.notifications.generators.move import MoveGen
from wiki.notifications.generators.owner import ChangeOwnerGen
from wiki.notifications.generators.page.edition import EditionGen as PageEdition
from wiki.notifications.generators.request_ownership import RequestOwnershipGen
from wiki.notifications.generators.request_page_author import RequestPageAuthorGen
from wiki.notifications.generators.watch import WatchGen
from wiki.notifications.generators.deletion import DeletionGen
from wiki.pages.models import Page

creation = CreationGen()
change_owner = ChangeOwnerGen()
add_comment = AddCommentGen()
move_cluster = MoveGen()
keywords = KeywordsGen()
watch = WatchGen()
add_file = AddFileGen()
request_ownership = RequestOwnershipGen()
mark_actuality_gen = MarkActualityGen()
request_page_author = RequestPageAuthorGen()
change_author = ChangeAuthorGen()
change_access = ChangeAccessGen()
deletion = DeletionGen()

ORDER = {
    Page.TYPES.PAGE: [
        PageEdition(),
        creation,
        deletion,
        change_owner,
        add_comment,
        move_cluster,
        keywords,
        watch,
        add_file,
        request_ownership,
        mark_actuality_gen,
        request_page_author,
        change_author,
        change_access,
    ],
    Page.TYPES.GRID: [
        GridEdition(),
        creation,
        deletion,
        change_owner,
        add_comment,
        move_cluster,
        keywords,
        watch,
        add_file,
        request_ownership,
        mark_actuality_gen,
        request_page_author,
        change_author,
        change_access,
    ],
}

if settings.IS_INTRANET or settings.IS_BUSINESS:
    from wiki.notifications.generators.request_access import AccessRequestGen
    from wiki.notifications.generators.access_resolution import AccessResolutionGen

    access_request = AccessRequestGen()
    access_resolution = AccessResolutionGen()

    ORDER[Page.TYPES.PAGE].extend(
        [
            access_request,
            access_resolution,
        ]
    )
    ORDER[Page.TYPES.GRID].extend(
        [
            access_request,
            access_resolution,
        ]
    )
