from django.template.loader import render_to_string
from django.utils import translation
from django.utils.translation import ugettext

from wiki.notifications.generators.base import BaseGen, EmailDetails, remove_watch
from wiki.pages.dao import page as page_dao
from wiki.pages.logic import subscription


class CreateDeleteOpBaseGen(BaseGen):
    def should_be_send(self, event):
        supertag = '/'.join(event.page.supertag.split('/')[:-1])
        if not supertag:
            return False

        parent_page = page_dao.get_page_by_supertag(supertag)
        if parent_page is None:
            return False

        return True

    def generate(self, events, subject_key, template_name):
        e = events[0]
        if not self.should_be_send(e):
            return self.reply

        author = e.author
        page = e.page
        # cause events ordered by created_at DESC

        watchers = subscription.get_united_subscribed_users(page)

        for user in watchers:
            if user == author:
                continue

            if not page.has_access(user):
                remove_watch(user, page)
                continue

            if getattr(user.staff, 'is_dismissed', False):
                continue

            e_lang = self.email_language(user, strict_mode=True)
            if e_lang is None:
                continue

            email, receiver_name, language = e_lang
            translation.activate(language)
            subject = ugettext(subject_key) % {
                'cluster': self.page_name_for_print(page),
                'title': self.page_title_for_print(page),
                'wiki_entity': page.subjective,
            }

            params = self.default_params.copy()
            params.update(
                {
                    'event': e,
                    'page_title': self.page_title_for_print(page),
                    'page_tag': page.tag,
                }
            )
            self.add_chunk(
                EmailDetails._replace(
                    receiver_email=email,
                    receiver_name=receiver_name,
                    receiver_lang=language,
                    subject=subject,
                    author_name=author.staff.inflections.subjective,
                    reply_to=author.staff.get_email(),
                ),
                render_to_string(f'{template_name}', params),
            )

        return self.reply
