
from wiki.notifications.generators.base import EventTypes, supply_events
from wiki.notifications.generators.create_delete_base import CreateDeleteOpBaseGen


class CreationGen(CreateDeleteOpBaseGen):
    @supply_events(EventTypes.create)
    def generate(self, events, settings):
        return super().generate(
            events=events,
            subject_key='Created a %(wiki_entity)s: in cluster %(cluster)s titled %(title)s',
            template_name='creation.html',
        )
