from wiki.i18n.string_constants import MSG_EMAIL_DELETED_WIKI_ENTITY
from wiki.notifications.generators.base import EventTypes, supply_events
from wiki.notifications.generators.create_delete_base import CreateDeleteOpBaseGen


class DeletionGen(CreateDeleteOpBaseGen):
    def should_be_send(self, event):
        # отключаем проверку на родителя
        return True

    @supply_events(EventTypes.delete)
    def generate(self, events, settings):
        return super().generate(
            events=events,
            subject_key=MSG_EMAIL_DELETED_WIKI_ENTITY,
            template_name='delete.html',
        )
