
import base64

from django.conf import settings as glob_settings
from django.template.loader import render_to_string
from django.utils import translation
from django.utils.translation import ugettext

from wiki.notifications.generators.base import BaseGen, EmailDetails, EventTypes, remove_watch, supply_events
from wiki.pages.logic import subscription

IS_INTRANET = getattr(glob_settings, 'IS_INTRANET', False)


class KeywordsGen(BaseGen):
    @supply_events(EventTypes.keywords)
    def generate(self, events, settings):
        e = events[0]
        watchers = subscription.get_united_subscribed_users(e.page)

        for user in watchers:
            if user == e.author:
                continue

            if not e.page.has_access(user):
                remove_watch(user, e.page)
                continue
            if getattr(user.staff, 'is_dismissed', False):
                continue

            tmp = self.email_language(user, strict_mode=True)
            if tmp is None:
                continue

            email, name, lang = tmp
            translation.activate(lang)
            subject = ugettext('Keywords changed: on page %(cluster)s titled %(title)s') % {
                'cluster': self.page_name_for_print(e.page),
                'title': self.page_title_for_print(e.page),
            }

            params = self.default_params.copy()
            if e.meta.get('django_keywords'):
                keywords = e.meta['django_keywords']
            else:
                keywords = base64.decodebytes(e.meta['keywords'].encode('UTF-8')).decode('UTF-8')
            params.update(
                {
                    'event': e,
                    'keywords': keywords,
                    'page_tag': e.page.tag,
                    'page_title': self.page_title_for_print(e.page),
                }
            )
            self.add_chunk(
                EmailDetails._replace(
                    receiver_email=email,
                    receiver_name=name,
                    receiver_lang=lang,
                    subject=subject,
                    author_name=e.author.staff.inflections.subjective,
                    reply_to=e.author.staff.get_email(),
                ),
                render_to_string('keywords.html', params),
            )

        return self.reply
