
from django.utils import translation


def format_for_nice_datetime(seconds=False):
    """
    Вернуть формат даты для шаблона, если надо, то с секундами.
    """
    if translation.get_language().lower().startswith('ru'):
        template = 'j E Y, H:i{seconds}'
    else:
        # english and other
        template = 'H:i{seconds}, j E, Y'
    return template.format(seconds=':s' if seconds else '')
