# Generated by Django 1.9.9 on 2017-01-27 16:26


from django.conf import settings
from django.db import migrations, models
import wiki.notifications.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('notifications', '0002_auto_20160823_1748'),
    ]

    operations = [
        migrations.CreateModel(
            name='Event',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField()),
                ('timeout', models.DateTimeField()),
                ('sent_at', models.DateTimeField(db_index=True, null=True)),
                (
                    'event_type',
                    models.IntegerField(
                        choices=[
                            (b'create', 1),
                            (b'delete', 2),
                            (b'edit', 3),
                            (b'access', 4),
                            (b'request_access', 5),
                            (b'keywords', 6),
                            (b'rename', 7),
                            (b'add_file', 8),
                            (b'delete_file', 9),
                            (b'add_comment', 10),
                            (b'delete_comment', 11),
                            (b'watch', 12),
                            (b'unwatch', 13),
                            (b'resolve_access', 14),
                            (b'closed_page_access', 15),
                            (b'change_owner', 16),
                            (b'move_cluster', 17),
                            (b'remove_comment', 18),
                            (b'request_ownership', 19),
                            (b'change_to_redirect', 20),
                            (b'revert_from_redirect', 21),
                            (b'mark_obsolete', 22),
                            (b'mark_actual', 23),
                            (b'subscribe_other_user', 24),
                        ],
                        default=1,
                    ),
                ),
                ('notify', models.BooleanField(default=True)),
                ('meta', wiki.notifications.models.PageEventMetaField(max_length=250)),
                (
                    'author',
                    models.ForeignKey(
                        related_name='author_events',
                        to=settings.AUTH_USER_MODEL,
                        on_delete=models.CASCADE,
                    ),
                ),
                (
                    'page',
                    models.ForeignKey(
                        related_name='page_events', to='pages.Page', on_delete=models.CASCADE
                    ),
                ),
            ],
            options={
                'db_table': 'notifications_event',
            },
        ),
        migrations.CreateModel(
            name='EventLink',
            fields=[
                (
                    'page_event',
                    models.OneToOneField(
                        primary_key=True,
                        related_name='page_event_links',
                        serialize=False,
                        to='notifications.PageEvent',
                        on_delete=models.CASCADE,
                    ),
                ),
                (
                    'event',
                    models.OneToOneField(
                        related_name='event_links',
                        to='notifications.Event',
                        on_delete=models.CASCADE,
                    ),
                ),
            ],
            options={
                'db_table': 'notifications_eventlink',
            },
        ),
        migrations.AlterModelTable(
            name='pageevent',
            table='notifications_pageevent',
        ),
    ]
