
from django.conf import settings
from django import template
from django.utils.safestring import mark_safe
from django.utils.translation import ugettext, get_language
from django.contrib.auth import get_user_model

from wiki.intranet.models import Staff
from wiki.legacy.translit import name_translit


IS_INTRANET = getattr(settings, 'IS_INTRANET', False)

register = template.Library()


def safe_marker(func):
    def call(*args, **kwargs):
        return mark_safe(func(*args, **kwargs))

    return call


@register.simple_tag
def link_to_staff(user, form='subjective'):
    staff = None
    if isinstance(user, Staff):
        staff = user
    elif isinstance(user, get_user_model()):
        try:
            staff = user.staff
        except Staff.DoesNotExist:
            pass
    if staff is None:
        return mark_safe('%s (%s)' % (str(user), ugettext('not synced with center')))
    language = get_language().lower()
    if language.startswith('en'):
        staff_name = staff.get_full_name()
    else:
        staff_name = getattr(staff.inflections, form)
    if not IS_INTRANET:
        return mark_safe(staff_name)
    if language.startswith('en'):
        staff_name = name_translit(staff_name)
    return mark_safe(
        "<a href=\"https://staff.yandex-team.ru/{login}\">{staff_name}</a>".format(
            login=staff.login, staff_name=staff_name
        )
    )
