from typing import Literal

from ninja import Schema, Field
from pydantic import HttpUrl

from wiki.notifications_v2.schemas import EnRuField, PageField, UserInflectField


class AccessLinkField(Schema):
    grant: HttpUrl
    deny: HttpUrl


class NotifyDataForRequestAccess(Schema):
    authorName: EnRuField = Field(default=None, description='Заполняется после')
    userStaff: EnRuField
    userName: EnRuField
    userInflect: UserInflectField
    page: PageField
    accessLink: AccessLinkField
    userVerb: Literal['', 'а'] = Field(description='Для склонения глаголов')
    reason: str
    docLink: HttpUrl
