# coding: utf-8
# flake8: noqa

from django.conf import settings

from wiki.sync.connect.org_ctx import (
    get_org,
    get_org_dir_id,
    get_org_id,
    get_org_lang,
    get_org_or_none,
    org_ctx,
    org_user,
    get_user_orgs as dir_user_orgs,
    NoOrgCtxException,
)  # импортируются отсюда другим кодом
from wiki.intranet.models import Staff
from wiki.users.models import Group


def org_staff():
    if settings.IS_BUSINESS:
        return Staff.objects.filter(user__orgs=get_org())
    else:
        return Staff.objects


def org_group():
    if settings.IS_BUSINESS:
        return Group.objects.filter(org=get_org())
    else:
        return Group.objects


def active_org_group():
    if settings.IS_BUSINESS:
        return Group.active.filter(org=get_org())
    else:
        return Group.active


def get_user_orgs(user, assert_empty_org=True):
    return dir_user_orgs(user, assert_empty_org)
