from logging import getLogger

from wiki.pages.access.access_status import _get_page_authors_with_inherited, has_common_access, ACCESS_COMMON
from wiki.pages.access.groups import user_group_ids
from wiki.pages.access.raw import get_raw_access
from wiki.pages.models import Access

log = getLogger(__name__)

"""
В модуле pages.access.access_status есть два метода проверки доступа, зачем тут третий?
 - два имеют особенности реализации (работают по-разному, хотя делают одно и тоже)
 - возвращают ответ из категории вида "какой доступ" вместо "Да/Нет"
 - функция проверки не чистая (учитывает окружение, включен ли ридонли),
"""


class LegacyAclCache:
    def __init__(self):
        self.raw_access_list = {}
        self.authors_cache = {}
        self.page_cache = {}


def check_common_access(user, privilege):
    return has_common_access(user, privilege) == ACCESS_COMMON


def check_access(page, user, privilege='read', staff=None, cache: LegacyAclCache = None):
    if cache is None:
        cache = LegacyAclCache()

    if not user.is_authenticated:
        return False

    raw_access = cache.raw_access_list.get(page)
    if raw_access is None:
        raw_access = get_raw_access(page)
        cache.raw_access_list[page] = raw_access

    authors = cache.authors_cache.get(page)

    if authors is None:
        authors = _get_page_authors_with_inherited(page, raw_access, cache.page_cache)
        cache.authors_cache[page] = authors

    if user in authors:
        if raw_access['list_len'] > 0:
            return True

    if not raw_access['list_len']:  # Если Access моделей нет, то используется дефолтный ACL (только для стаффа)
        return check_common_access(user, privilege)

    # Если Access-модель одна, то обработать её - скорее всего она содержит is_common или is_owner

    if raw_access['list_len'] == 1 and isinstance(raw_access['list'][0], Access):
        if raw_access['list'][0].is_common:
            return has_common_access(user, privilege)
        elif raw_access['list'][0].is_owner:
            return False  # мы уже проверили что пользователь не входит в авторы, значит нет
        elif raw_access['list'][0].is_anonymous:
            raise ValueError('Anonymous access is deprecated!')

    staff = staff or user.staff

    if staff:
        group_ids = user_group_ids(staff)
    else:
        group_ids = []

    for ac in raw_access['list']:
        if staff and ac.staff and ac.staff == staff:
            return True
        elif group_ids and ac.group and ac.group.id in group_ids:
            return True

    return False
