from dataclasses import dataclass
from dataclasses import field
from typing import Optional, List

from wiki.pages.models.consts import AclType
from wiki.users.models import User, Group


@dataclass
class LegacyAcl:
    acl_type: AclType
    break_inheritance: bool
    inherits_from: Optional[str] = None

    is_readonly: bool = False

    users: Optional[List[User]] = field(default_factory=list)
    groups: Optional[List[Group]] = field(default_factory=list)
